////////////////////////////////////////////////////////
// PostEffect Bloom Blur - Fragment Shader
//
// Blur effect for the bloom post effect
////////////////////////////////////////////////////////
#version 120

#extension GL_ARB_texture_rectangle : enable

uniform sampler2DRect diffuseMap;
@define sampler_diffuseMap 0

uniform sampler1D convMap;
@define sampler_convMap 1

@ifdef UseFadeAlpha
	uniform float afFadeAlpha;
@endif

void main()
{
	vec3 vDiffuseColor = texture2DRect(diffuseMap, gl_TexCoord[0].xy).xyz;
	
    // This is the original sepia shader used for amnesia - color conversion shader
	vec3 vOutput =  vec3(texture1D(convMap, vDiffuseColor.x * 0.5).x,
			  	 texture1D(convMap, vDiffuseColor.y * 0.5).y,
				 texture1D(convMap, vDiffuseColor.z * 0.5).z);
    
    float third = 1.0 / 3.0;
    float gray = dot(vDiffuseColor, vec3(third, third, third)); // Grayscale value 

    // This is the color-replacement shader
    vec3 vReplacementColor = texture1D(convMap, gray * 0.5).xyz;
  
    // the right part of the gradient determines the blend amount between the two shader algorithms; black = 0% , white = 100%
    float blendAmmount = texture1D(convMap, 0.9).x;  
    

    vOutput =  mix(vOutput, vReplacementColor, blendAmmount);
    
	
	@ifdef UseFadeAlpha
		gl_FragColor.xyz = vOutput*afFadeAlpha + vDiffuseColor*(1-afFadeAlpha);
	@else
		gl_FragColor.xyz = vOutput;	
	@endif	
}